% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeDates.R
\name{computeDate_wkyr}
\alias{computeDate_wkyr}
\title{Creates a date with the format year/calendar week}
\usage{
computeDate_wkyr(day=NULL, month=NULL, year= NULL)
}
\arguments{
\item{day}{atomic numeric or integer.}

\item{month}{atomic numeric or integer.}

\item{year}{atomic numeric or integer.}
}
\value{
Returns a atomic character of the structure year / calendar week.
}
\description{
R Implementation of the SPSS \code{DATE.WKYR} Function. \code{computeDate_wkyr} is a helper function for xpssCompute.
}
\details{
An character string as Date. Returns a date value corresponding to the indicated month, and year. The arguments must resolve to integers or numerics, with day between 1 and 31, month between 1 and 12, and year a four-digit integer value.
}
\examples{
xpssCompute(x=5, fun="computeDate_wkyr", month=10, year=2006)
xpssCompute(x=10, fun="computeDate_wkyr", month=1, year=2010)
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{computeDate_qyr}} \code{\link{computeDate_yrday}}
}
\keyword{internal}

