% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformer_scores.R
\name{transformer_scores}
\alias{transformer_scores}
\title{Sentiment Analysis Scores from Facebook BART Large}
\usage{
transformer_scores(
  text,
  classes,
  multiple_classes = FALSE,
  path_to_python = NULL,
  keep_in_env = TRUE,
  envir = 1
)
}
\arguments{
\item{text}{Character vector or list.
Text in a vector or list data format}

\item{classes}{Character vector.
Classes to score the text}

\item{multiple_classes}{Boolean.
Whether the text can belong to multiple true classes.
Defaults to \code{FALSE}.
Set to \code{TRUE} to get scores with multiple classes}

\item{path_to_python}{Character.
Path to specify where "python.exe" is located on your computer.
Defaults to \code{NULL}, which will use \code{\link[reticulate]{py_available}}
to find available Python or Anaconda}

\item{keep_in_env}{Boolean.
Whether the classifier should be kept in your global environment.
Defaults to \code{TRUE}.
By keeping the classifier in your environment, you can skip
re-loading the classifier every time you run this function.
\code{TRUE} is recommended}

\item{envir}{Numeric.
Environment for the classifier to be saved for repeated use.
Defaults to the global environment}
}
\value{
Returns probabilities for the text classes
}
\description{
Checkpoint for \href{https://huggingface.co/facebook/bart-large-mnli}{Facebook's BART Large} trained on the
Multi-Genre Natural Language Inference \href{https://huggingface.co/datasets/multi_nli}{MultiNLI} dataset. Scores represent
the probabilities that the text corresponds to the specified classes
}
\details{
This function requires that you have both Python and the 
"transformers" module installed on your computer. For help installing Python 
and Python modules, see \code{browseVignettes("emoxicon")} and click on
HTML for the "Python Setup" vignette.

Once both Python and the "transformers" module are installed, the
function will automatically download the necessary model to compute the
scores.
}
\examples{
# Load data
data(neo_ipip_extraversion)

# Example text 
text <- neo_ipip_extraversion$friendliness

\dontrun{
transformer_scores(
  text = text,
  classes = c("sociable", "warm", "assertive", "positive"),
  multiple_classes = FALSE
)
}

}
\references{
Lewis, M., Liu, Y., Goyal, N., Ghazvininejad, M., Mohamed, A., Levy, O., ... & Zettlemoyer, L. (2019).
Bart: Denoising sequence-to-sequence pre-training for natural language generation, translation, and comprehension.
\emph{arXiv preprint arXiv:1910.13461}.

Yin, W., Hay, J., & Roth, D. (2019).
Benchmarking zero-shot text classification: Datasets, evaluation and entailment approach.
\emph{arXiv preprint arXiv:1909.00161}.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
