% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{TrajSplit}
\alias{TrajSplit}
\title{Split a trajectory into multiple sections}
\usage{
TrajSplit(trj, idx)
}
\arguments{
\item{trj}{The trajectory to be split}

\item{idx}{Indices of splits. Each new section starts at one of these
indices.}
}
\value{
A list containing one or more trajectories. The first trajectory in
  the list contains the first points from \code{trj}. Remaining trajectories
  contain the points starting from each of the \code{idx} values, in
  ascending order.
}
\description{
Every point in \code{trj} will belong to exactly one of the returned
sections. Note that this function will happily create single point
trajectories.
}
\seealso{
\code{\link{TrajMerge}}, \code{\link{TrajSplitAtFirstCrossing}}
}
