% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{logtrafo}
\alias{logtrafo}
\title{Log transformation for linear models}
\usage{
logtrafo(object)
}
\arguments{
\item{object}{an object of type lm.}
}
\value{
An object of class \code{trafo}. Methods such as 
\code{\link{as.data.frame.trafo}} and \code{\link{print.trafo}} can 
be used for this class.
}
\description{
The function transforms the dependent variable of a linear model using the 
Log transformation. The Log transformation is only defined for positive 
response values. In case the response contains zero or negative values
a shift is automatically added such that y + shift > 0.
}
\examples{
# Load data
data("cars", package = "datasets")

# Fit linear model
lm_cars <- lm(dist ~ speed, data = cars)

# Transform dependent variable 
logtrafo(object = lm_cars)
}
\references{
Box GEP, Cox DR (1964). An Analysis of Transformations. Journal of the Royal 
Statistical Society B, 26(2), 211-252.
}
