% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-clustered.R
\name{tp_summary_clustered}
\alias{tp_summary_clustered}
\title{Stata-Like Clustered Standard Errors Summary}
\usage{
tp_summary_clustered(model, cluster)
}
\arguments{
\item{model}{\code{lm} or \code{glm} object}

\item{cluster}{Clustering variable in the model data (e.g.
\code{"pair_id"})}
}
\value{
A list
}
\description{
Returns a list for a a general \code{lm} or \code{glm} which returns number
of observations, F-statistic (with degrees of freedom and p-value), R-squared
(and pseudo R-squared for Poisson-type generalized models), root MSE and clustered
standard errors for estimated coefficients.
}
\examples{
# These regressions constitute a dummy example
model1 <- lm(mpg ~ wt, data = mtcars)
tp_summary_clustered(model1, "cyl")

model2 <- glm(mpg ~ wt, data = mtcars, family = quasipoisson)
tp_summary_clustered(model2, "cyl")
}
