% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_sparse.R
\docType{class}
\name{SparseArray-class}
\alias{SparseArray-class}
\alias{SparseArray}
\title{The SparseArray class}
\description{
This class represents an array with any number of dimensions, in which a
significant proportion of entries are zero. The coordinates of nonzero
entries are stored along with their values, with all remaining entries
assumed to be zero. Methods are provided to index into the array in the
standard way, using matrix or vector indices; and for coercing between
\code{SparseArray} objects and standard (dense) arrays.
}
\section{Fields}{

\describe{
\item{\code{data}}{Vector of nonzero data values}

\item{\code{coords}}{Integer matrix of nonzero \code{data} locations, one per row}

\item{\code{dims}}{Integer vector of dimensions}
}}

\section{Methods}{

\describe{
\item{\code{aperm(perm)}}{Permute the dimensions of the array}

\item{\code{apply(margin, fun, ...)}}{Apply a function to margins of the array}

\item{\code{flip(dimsToFlip)}}{Flip the array along one or more directions}

\item{\code{setCoordinatesAndData(newCoords, newData)}}{Update the nonzero locations and data values in the array}

\item{\code{setDimensions(newDims)}}{Change the dimensions of the image}
}}

