% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_addr}
\alias{torch_addr}
\title{Addr}
\usage{
torch_addr(self, vec1, vec2, beta = 1L, alpha = 1L)
}
\arguments{
\item{self}{(Tensor) matrix to be added}

\item{vec1}{(Tensor) the first vector of the outer product}

\item{vec2}{(Tensor) the second vector of the outer product}

\item{beta}{(Number, optional) multiplier for \code{input} (\eqn{\beta})}

\item{alpha}{(Number, optional) multiplier for \eqn{\mbox{vec1} \otimes \mbox{vec2}} (\eqn{\alpha})}
}
\description{
Addr
}
\section{addr(input, vec1, vec2, *, beta=1, alpha=1, out=NULL) -> Tensor }{


Performs the outer-product of vectors \code{vec1} and \code{vec2}
and adds it to the matrix \code{input}.

Optional values \code{beta} and \code{alpha} are scaling factors on the
outer product between \code{vec1} and \code{vec2} and the added matrix
\code{input} respectively.

\deqn{
    \mbox{out} = \beta\ \mbox{input} + \alpha\ (\mbox{vec1} \otimes \mbox{vec2})
}
If \code{vec1} is a vector of size \code{n} and \code{vec2} is a vector
of size \code{m}, then \code{input} must be
broadcastable  with a matrix of size
\eqn{(n \times m)} and \code{out} will be a matrix of size
\eqn{(n \times m)}.

For inputs of type \code{FloatTensor} or \code{DoubleTensor}, arguments \code{beta} and
\code{alpha} must be real numbers, otherwise they should be integers
}

\examples{
if (torch_is_installed()) {

vec1 = torch_arange(1, 3)
vec2 = torch_arange(1, 2)
M = torch_zeros(c(3, 2))
torch_addr(M, vec1, vec2)
}
}
