% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_searchsorted}
\alias{torch_searchsorted}
\title{Searchsorted}
\usage{
torch_searchsorted(sorted_sequence, self, out_int32 = FALSE, right = FALSE)
}
\arguments{
\item{sorted_sequence}{(Tensor) N-D or 1-D tensor, containing monotonically increasing
sequence on the \emph{innermost} dimension.}

\item{self}{(Tensor or Scalar) N-D tensor or a Scalar containing the search value(s).}

\item{out_int32}{(bool, optional) – indicate the output data type. \code{\link[=torch_int32]{torch_int32()}}
if True, \code{\link[=torch_int64]{torch_int64()}} otherwise. Default value is FALSE, i.e. default output
data type is \code{\link[=torch_int64]{torch_int64()}}.}

\item{right}{(bool, optional) – if False, return the first suitable location
that is found. If True, return the last such index. If no suitable index found,
return 0 for non-numerical value (eg. nan, inf) or the size of boundaries
(one pass the last index). In other words, if False, gets the lower bound index
for each value in input from boundaries. If True, gets the upper bound index
instead. Default value is False.}
}
\description{
Searchsorted
}
\section{searchsorted(sorted_sequence, values, *, out_int32=FALSE, right=FALSE, out=None) -> Tensor }{


Find the indices from the \emph{innermost} dimension of \code{sorted_sequence} such that, if the
corresponding values in \code{values} were inserted before the indices, the order of the
corresponding \emph{innermost} dimension within \code{sorted_sequence} would be preserved.
Return a new tensor with the same size as \code{values}. If \code{right} is FALSE (default),
then the left boundary of \code{sorted_sequence} is closed.
}

\examples{
if (torch_is_installed()) {

sorted_sequence <- torch_tensor(rbind(c(1, 3, 5, 7, 9), c(2, 4, 6, 8, 10)))
sorted_sequence
values <- torch_tensor(rbind(c(3, 6, 9), c(3, 6, 9)))
values
torch_searchsorted(sorted_sequence, values)
torch_searchsorted(sorted_sequence, values, right=TRUE)
sorted_sequence_1d <- torch_tensor(c(1, 3, 5, 7, 9))
sorted_sequence_1d
torch_searchsorted(sorted_sequence_1d, values)
}
}
