% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jit-compile.R
\name{jit_compile}
\alias{jit_compile}
\title{Compile TorchScript code into a graph}
\usage{
jit_compile(source)
}
\arguments{
\item{source}{valid TorchScript source code.}
}
\description{
See the \href{https://pytorch.org/docs/stable/jit_language_reference.html#language-reference}{TorchScript language reference} for
documentation on how to write TorchScript code.
}
\examples{
if (torch_is_installed()) {
comp <- jit_compile("
def fn (x):
  return torch.abs(x)
  
def foo (x):
  return torch.sum(x)

")

comp$fn(torch_tensor(-1))
comp$foo(torch_randn(10))

}
}
