% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_softmax}
\alias{nn_softmax}
\title{Softmax module}
\usage{
nn_softmax(dim)
}
\arguments{
\item{dim}{(int): A dimension along which Softmax will be computed (so every slice
along dim will sum to 1).}
}
\value{
:
a Tensor of the same dimension and shape as the input with
values in the range \verb{[0, 1]}
}
\description{
Applies the Softmax function to an n-dimensional input Tensor
rescaling them so that the elements of the n-dimensional output Tensor
lie in the range \verb{[0,1]} and sum to 1.
Softmax is defined as:
}
\details{
\deqn{
  \mbox{Softmax}(x_{i}) = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
}

When the input Tensor is a sparse tensor then the unspecifed
values are treated as \code{-Inf}.
}
\note{
This module doesn't work directly with NLLLoss,
which expects the Log to be computed between the Softmax and itself.
Use \code{LogSoftmax} instead (it's faster and has better numerical properties).
}
\section{Shape}{

\itemize{
\item Input: \eqn{(*)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(*)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_softmax(1)
input <- torch_randn(2, 3)
output <- m(input)

}
}
