% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-distance.R
\name{nnf_cosine_similarity}
\alias{nnf_cosine_similarity}
\title{Cosine_similarity}
\usage{
nnf_cosine_similarity(x1, x2, dim = 1, eps = 1e-08)
}
\arguments{
\item{x1}{(Tensor) First input.}

\item{x2}{(Tensor) Second input (of size matching x1).}

\item{dim}{(int, optional) Dimension of vectors. Default: 1}

\item{eps}{(float, optional) Small value to avoid division by zero.
Default: 1e-8}
}
\description{
Returns cosine similarity between x1 and x2, computed along dim.
}
\details{
\deqn{
    \mbox{similarity} = \frac{x_1 \cdot x_2}{\max(\Vert x_1 \Vert _2 \cdot \Vert x_2 \Vert _2, \epsilon)}
}
}
