% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_heaviside}
\alias{torch_heaviside}
\title{Heaviside}
\usage{
torch_heaviside(self, values)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{values}{(Tensor) The values to use where \code{input} is zero.}
}
\description{
Heaviside
}
\section{heaviside(input, values, *, out=None) -> Tensor }{


Computes the Heaviside step function for each element in \code{input}.
The Heaviside step function is defined as:

\deqn{
\mbox{{heaviside}}(input, values) = \begin{array}{ll}
 0, & \mbox{if input < 0}\\
 values, & \mbox{if input == 0}\\
 1, & \mbox{if input > 0}
 \end{array}
}
}

\examples{
if (torch_is_installed()) {

input <- torch_tensor(c(-1.5, 0, 2.0))
values <- torch_tensor(c(0.5))
torch_heaviside(input, values)
values <- torch_tensor(c(1.2, -2.0, 3.5))
torch_heaviside(input, values)
}
}
