% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_inv_ex}
\alias{linalg_inv_ex}
\title{Computes the inverse of a square matrix if it is invertible.}
\usage{
linalg_inv_ex(A, check_errors = FALSE)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions
consisting of square matrices.}

\item{check_errors}{(bool, optional): controls whether to check the content of \code{info}. Default: \code{FALSE}.}
}
\description{
Returns a namedtuple \verb{(inverse, info)}. \code{inverse} contains the result of
inverting \code{A} and \code{info} stores the LAPACK error codes.
If \code{A} is not an invertible matrix, or if it's a batch of matrices
and one or more of them is not an invertible matrix,
then \code{info} stores a positive integer for the corresponding matrix.
The positive integer indicates the diagonal element of the LU decomposition of
the input matrix that is exactly zero.
\code{info} filled with zeros indicates that the inversion was successful.
If \code{check_errors=TRUE} and \code{info} contains positive integers, then a RuntimeError is thrown.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\note{
If \code{A} is on a CUDA device then this function may synchronize
that device with the CPU.

This function is "experimental" and it may change in a future PyTorch release.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(3, 3)
out <- linalg_inv_ex(A)
}
}
\seealso{
\code{\link[=linalg_inv]{linalg_inv()}} is a NumPy compatible variant that always checks for errors.

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
