% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{torch_tensor}
\alias{torch_tensor}
\title{Converts R objects to a torch tensor}
\usage{
torch_tensor(
  data,
  dtype = NULL,
  device = NULL,
  requires_grad = FALSE,
  pin_memory = FALSE
)
}
\arguments{
\item{data}{an R atomic vector, matrix or array}

\item{dtype}{a \link{torch_dtype} instance}

\item{device}{a device creted with \code{\link[=torch_device]{torch_device()}}}

\item{requires_grad}{if autograd should record operations on the returned tensor.}

\item{pin_memory}{If set, returned tensor would be allocated in the pinned memory.}
}
\description{
Converts R objects to a torch tensor
}
\examples{
if (torch_is_installed()) {
torch_tensor(c(1,2,3,4))
torch_tensor(c(1,2,3,4), dtype = torch_int())

}
}
