% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_svd}
\alias{torch_svd}
\title{Svd}
\arguments{
\item{input}{(Tensor) the input tensor of size \eqn{(*, m, n)} where \code{*} is zero or more                    batch dimensions consisting of \eqn{m \times n} matrices.}

\item{some}{(bool, optional) controls the shape of returned \code{U} and \code{V}}

\item{compute_uv}{(bool, optional) option whether to compute \code{U} and \code{V} or not}

\item{out}{(tuple, optional) the output tuple of tensors}
}
\description{
Svd
}
\note{
The singular values are returned in descending order. If \code{input} is a batch of matrices,
then the singular values of each matrix in the batch is returned in descending order.

The implementation of SVD on CPU uses the LAPACK routine \code{?gesdd} (a divide-and-conquer
algorithm) instead of \code{?gesvd} for speed. Analogously, the SVD on GPU uses the MAGMA routine
\code{gesdd} as well.

Irrespective of the original strides, the returned matrix \code{U}
will be transposed, i.e. with strides \verb{U.contiguous().transpose(-2, -1).stride()}

Extra care needs to be taken when backward through \code{U} and \code{V}
outputs. Such operation is really only stable when \code{input} is
full rank with all distinct singular values. Otherwise, \code{NaN} can
appear as the gradients are not properly defined. Also, notice that
double backward will usually do an additional backward through \code{U} and
\code{V} even if the original backward is only on \code{S}.

When \code{some} = \code{False}, the gradients on \verb{U[..., :, min(m, n):]}
and \verb{V[..., :, min(m, n):]} will be ignored in backward as those vectors
can be arbitrary bases of the subspaces.

When \code{compute_uv} = \code{False}, backward cannot be performed since \code{U} and \code{V}
from the forward pass is required for the backward operation.
}
\section{svd(input, some=True, compute_uv=True, out=None) -> (Tensor, Tensor, Tensor) }{


This function returns a namedtuple \verb{(U, S, V)} which is the singular value
decomposition of a input real matrix or batches of real matrices \code{input} such that
\eqn{input = U \times diag(S) \times V^T}.

If \code{some} is \code{True} (default), the method returns the reduced singular value decomposition
i.e., if the last two dimensions of \code{input} are \code{m} and \code{n}, then the returned
\code{U} and \code{V} matrices will contain only \eqn{min(n, m)} orthonormal columns.

If \code{compute_uv} is \code{False}, the returned \code{U} and \code{V} matrices will be zero matrices
of shape \eqn{(m \times m)} and \eqn{(n \times n)} respectively. \code{some} will be ignored here.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(5, 3))
a
out = torch_svd(a)
u = out[[1]]
s = out[[2]]
v = out[[3]]
torch_dist(a, torch_mm(torch_mm(u, torch_diag(s)), v$t()))
a_big = torch_randn(c(7, 5, 3))
out = torch_svd(a_big)
u = out[[1]]
s = out[[2]]
v = out[[3]]
torch_dist(a_big, torch_matmul(torch_matmul(u, torch_diag_embed(s)), v$transpose(-2, -1)))
}
}
