% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genes_and_annotation.R
\name{get_genes_in_region}
\alias{get_genes_in_region}
\title{Get SNPs/variants within region}
\usage{
get_genes_in_region(
  chr = chr,
  xmin = xmin,
  xmax = xmax,
  protein_coding_only = F,
  show_exons = F,
  show_genes = T,
  build = 38,
  region = NULL
)
}
\arguments{
\item{chr}{A string, chromosome (e.g. chr16)}

\item{xmin}{An integer representing genetic position}

\item{xmax}{An integer representing genetic position}

\item{protein_coding_only}{A logical scalar, if TRUE, only protein coding genes are used for annotation}

\item{show_exons}{Deprecated : A logical scalar, show exons instead of genes (default show_exons=FALSE)}

\item{show_genes}{A logical scalar, show genes instead of exons (default show_genes=FALSE)}

\item{build}{A number representing the genome build. Set to 37 to change to build (GRCh37). The default is build 38 (GRCh38).}

\item{region}{A string representing the genetic region (e.g chr16:50693587-50734041)}
}
\value{
the genes the requested region
}
\description{
\code{get_genes_in_region()}
}
\examples{
\dontrun{
get_genes_in_region(region="chr16:50593587-50834041")
} 
}
