% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{likelihood_function}
\alias{likelihood_function}
\title{Evaluate Likelihood with Cross-Validation}
\usage{
likelihood_function(
  distance_matrix,
  mapping_max_iter,
  relative_epsilon,
  N,
  k0,
  cooling_rate,
  c_repulsion,
  folds = 20,
  num_cores = 1
)
}
\arguments{
\item{distance_matrix}{Distance matrix to fit}

\item{mapping_max_iter}{Maximum map optimization iterations}

\item{relative_epsilon}{Convergence threshold}

\item{N}{Number of dimensions}

\item{k0}{Initial spring constant}

\item{cooling_rate}{Spring constant decay rate}

\item{c_repulsion}{Repulsion constant}

\item{folds}{Number of CV folds}

\item{num_cores}{Number of cores for parallel processing}
}
\value{
List with:
\item{Holdout_MAE}{Mean absolute error on validation data}
\item{NLL}{Negative log likelihood}
}
\description{
Calculates cross-validated likelihood for a set of parameters by:
\enumerate{
\item Splitting data into training/validation sets
\item Fitting model on training data
\item Evaluating likelihood on validation set
\item Repeating across folds
To calculate one NLL per set of parameters, the function uses a pooled errors approach which combines
all validation errors into one set, then calculate a single NLL. This approach has two main advantages:
1- It treats all validation errors equally, respecting the underlying error distribution assumption
2- It properly accounts for the total number of validation points
}
}
\keyword{internal}
