% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenvis.r
\name{colorscaled_browser}
\alias{colorscaled_browser}
\title{Convert tokens into full texts in an HTML file with color ramp highlighting}
\usage{
colorscaled_browser(
  tokens,
  value,
  alpha = 0.4,
  meta = NULL,
  col_range = c("red", "blue"),
  doc_col = "doc_id",
  token_col = "token",
  doc_nav = NULL,
  token_nav = NULL,
  filename = NULL,
  span_adjacent = T,
  ...
)
}
\arguments{
\item{tokens}{A data.frame with a column for document ids (doc_col)
and a column for tokens (token_col)}

\item{value}{A numeric vector with values between -1 and 1. Determines the color
mixture of the scale colors specified in col_range}

\item{alpha}{Optionally, the alpha (transparency) can be specified, with 0 being fully
transparent and 1 being fully colored. This can be a vector to specify a
different alpha for each value.}

\item{meta}{A data.frame with a column for document_ids (doc_col). All other columns are added
to the browser as document meta}

\item{col_range}{The color used to highlight}

\item{doc_col}{The name of the document id column}

\item{token_col}{The name of the token column}

\item{doc_nav}{The name of a column in meta, used to set a navigation tag}

\item{token_nav}{Alternative to doc_nav, a column in the tokens, used to set a navigation tag}

\item{filename}{Name of the output file. Default is temp file}

\item{span_adjacent}{If TRUE, include adjacent tokens with identical attributes within the same tag}

\item{...}{Additional formatting arguments passed to create_browser()}
}
\value{
The name of the file where the browser is saved. Can be opened conveniently from within R using browseUrl()
}
\description{
Convert tokens into full texts in an HTML file with color ramp highlighting
}
\examples{
## as an example, scale word colors based on number of characters
scale = nchar(as.character(sotu_data$tokens$token))
scale[scale>6] = scale[scale>6] +20
scale = rescale_var(sqrt(scale), -1, 1)
scale[abs(scale) < 0.5] = NA
url = colorscaled_browser(sotu_data$tokens, value = scale, meta=sotu_data$meta)

\donttest{
view_browser(url)   ## view browser in the Viewer
browseURL(url)     ## view browser in default webbrowser
}
}
