\name{createBubblechart}
\alias{createBubblechart}
\title{Create Bubble Chart type of plot.}
\usage{
  createBubblechart(data, x, y, z, label = z, fill = NULL,
    facet = NULL, ncol = 1, facetScales = "fixed",
    xlim = NULL, baseSize = 12, baseFamily = "sans",
    shape = 21, shapeColour = "black", scaleSize = TRUE,
    shapeSizeRange = c(3, 10), shapeMaxSize = 100,
    paletteValues = NULL, palette = "Set1",
    title = paste("Bubble Chart by", fill), xlab = x,
    ylab = y, labelSize = 5, labelFamily = "",
    labelFontface = "plain", labelColour = "black",
    labelVJust = 0.5, labelHJust = 0.5, labelAlpha = 1,
    labelAngle = 0, legendPosition = "right",
    defaultTheme = theme_bw(base_size = baseSize, base_family = baseFamily),
    themeExtra = NULL)
}
\arguments{
  \item{data}{data frame contains data computed for
  bubblechart}

  \item{x}{name of a column containing x variable values}

  \item{y}{name of a column containing y variable values}

  \item{z}{name of a column containing bubble size value}

  \item{label}{name of a column containing bubble label}

  \item{fill}{name of a column with values to use for
  bubble colours}

  \item{facet}{vector of 1 or 2 column names to split up
  data to plot the subsets as facets. If single name then
  subset plots are placed next to each other, wrapping with
  \code{ncol} number of columns (uses
  \code{\link{facet_wrap}}).  When two names then subset
  plots vary on both horizontal and vertical directions
  (grid) based on the column values (uses
  \code{\link{facet_grid}}).}

  \item{ncol}{number of facet columns (applies when single
  facet column supplied only - see parameter
  \code{facet}).}

  \item{facetScales}{Are scales shared across all subset
  plots (facets): "fixed" - all are the same, "free_x" -
  vary across rows (x axis), "free_y" - vary across columns
  (Y axis, default), "free" - both rows and columns (see in
  \code{facet_wrap} parameter \code{scales} )}

  \item{baseSize}{\code{\link{theme}} base font size}

  \item{baseFamily}{\code{\link{theme}} base font family}

  \item{xlim}{a vector specifying the data range for the x
  scale and the default order of their display in the x
  axis.}

  \item{shape}{bubble shape}

  \item{shapeColour}{colour of shapes}

  \item{scaleSize}{logical if TRUE then scale the size of
  shape to be proportional to the value, if FALSE then
  scale the area.}

  \item{shapeSizeRange}{bubble size range (applies only
  when \code{scaleSize = TRUE})}

  \item{shapeMaxSize}{size of largest shape (applies only
  when \code{scaleSize = FALSE})}

  \item{paletteValues}{actual palette colours for use with
  \code{scale_fill_manual} (if specified then parameter
  \code{palette} is ignored)}

  \item{palette}{Brewer palette name - see
  \code{display.brewer.all} in \code{RColorBrewer} package
  for names}

  \item{title}{plot title.}

  \item{xlab}{a label for the x axis, defaults to a
  description of x.}

  \item{ylab}{a label for the y axis, defaults to a
  description of y.}

  \item{labelSize}{size of labels}

  \item{labelFamily}{label font name or family name}

  \item{labelFontface}{label font face
  (\code{c("plain","bold","italic","bold.italic")})}

  \item{labelColour}{color of labels}

  \item{labelVJust}{position of the anchor (0=bottom edge,
  1=top edge), can go below 0 or above 1}

  \item{labelHJust}{position of the label anchor (0=left
  edge, 1=right edge), can go below 0 or above 1}

  \item{labelAlpha}{the transparency of the text label}

  \item{labelAngle}{the angle at which to draw the text
  label}

  \item{legendPosition}{the position of legends. ("left",
  "right", "bottom", "top", or two-element numeric vector).
  "none" is no legend.}

  \item{defaultTheme}{plot theme to use:
  \code{\link[ggplot2]{theme_bw}} (default),
  \code{\link[ggplot2]{theme_grey}},
  \code{\link[ggplot2]{theme_classic}} or custom.}

  \item{themeExtra}{any additional
  \code{\link[ggplot2]{theme}} settings that override
  default theme.}
}
\description{
  Create a bubble chart that utilizes three dimensions of
  data. It is a variation of the scatter plot with data
  points replaced with shapes ("bubbles"): x and y are
  bubble location and z is its size. It can optionally
  assign data points labels and fill shapes with colors.
}
\seealso{
  \code{\link{computeAggregates}} computes data for the
  bubble chart.
}

