% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliques.R
\name{cliques}
\alias{cliques}
\alias{cliques.tna}
\alias{cliques.group_tna}
\title{Identify Cliques in a Transition Network}
\usage{
cliques(x, ...)

\method{cliques}{tna}(x, size = 2, threshold = 0, sum_weights = FALSE, ...)

\method{cliques}{group_tna}(x, size = 2, threshold = 0, sum_weights = FALSE, ...)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object.}

\item{...}{Ignored.}

\item{size}{An \code{integer} specifying the size of the cliques to identify.
Defaults to \code{2} (dyads).}

\item{threshold}{A \code{numeric} value that sets the minimum edge weight
for an edge to be considered in the clique. Edges below this value
are ignored. Defaults to \code{0}.}

\item{sum_weights}{A \code{logical} value specifying whether the sum of the
weights should be above the \code{threshold} instead of individual weights of the
directed edges. Defaults to \code{FALSE}.}
}
\value{
A \code{tna_cliques} object which is a \code{list} of two elements:
\itemize{
\item \code{weights} is a \code{matrix} of the edge weights in the clique.
\item \code{inits} is a \code{numeric} vector of initial weights for the clique.
}

If \code{x} is a \code{group_tna} object, a \code{group_tna_cliques} object is returned
instead, which is a \code{list} or \code{tna_cliques} objects.
}
\description{
This function identifies cliques of a specified size in a transition network.
It searches for cliques, i.e., complete subgraphs where every pair of nodes
is connected, of size \code{n} in the transition matrix for the specified cluster
in the \code{tna} object.
}
\examples{
model <- tna(group_regulation)

# Find  2-cliques (dyads)
cliq <- cliques(model, size = 2)

model <- group_tna(engagement_mmm)
cliques(model)

}
\seealso{
Clique-related functions
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.tna_cliques}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.tna_cliques}()}
}
\concept{cliques}
