% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_cliques}
\alias{print.tna_cliques}
\title{Print Found Cliques of a TNA Network}
\usage{
\method{print}{tna_cliques}(x, n = 6, first = 1, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{A \code{tna_cliques} object.}

\item{n}{An \code{integer} defining the maximum number of cliques to show.
The defaults is \code{6}.}

\item{first}{An \code{integer} giving the index of the first clique to show.
The default index is \code{1}.}

\item{digits}{An \code{integer} giving the minimal number of
\emph{significant} digits to print.}

\item{...}{Ignored.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Found Cliques of a TNA Network
}
\examples{
model <- tna(group_regulation)
cliq <- cliques(model, size = 2)
print(cliq)

}
