% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_dots.R
\name{sample_dots}
\alias{sample_dots}
\title{Sample dots from spatial polygons}
\usage{
sample_dots(shp, vars = NULL, convert2density = FALSE, nrow = NA,
  ncol = NA, N = 250000, npop = NA, n = 10000, w = NA,
  shp.id = NULL, var.name = "class", var.labels = vars, unit = "km",
  unit.size = 1000, randomize = TRUE, ...)
}
\arguments{
\item{shp}{A shape object, more specifically, a \code{\link[sp:SpatialPolygonsDataFrame]{SpatialPolygonsDataFrame}}.}

\item{vars}{Names of one or more variables that are contained in \code{shp}. If \code{vars} is not provided, the dots are sampled uniformly. If \code{vars} consists of one variable name, the dots are sampled according to the distribution of the corresponding variable. If \code{vars} consist of more than one variable names, then the dots are sampled according to the distributions of those variables. A categorical variable is added that contains the distrubtion classes (see \code{var.name}).}

\item{convert2density}{Should the variables be converted to density values? Density values are used for the sampling algorithm, so use \code{TRUE} when the values are absolute counts.}

\item{nrow}{Number of grid rows}

\item{ncol}{Number of grid colums}

\item{N}{Number of grid points}

\item{npop}{Population total. If \code{NA}, it is recontructed from the data. If density values are specified, the population total is approximated using the polygon areas (see also \code{unit} and \code{unit.size}).}

\item{n}{Number of sampled dots}

\item{w}{Number of population units per dot. It is the population total divided by \code{n}. If specified, \code{n} is calculated accordingly.}

\item{shp.id}{Name of the variable of \code{shp} that contains the polygon identifying numbers or names.}

\item{var.name}{Name of the variable that will be created to store the classes. The classes are defined by \code{vars}, and the labels can be configured with \code{var.labels}.}

\item{var.labels}{Labels of the classes (see \code{var.name}).}

\item{unit}{Unit, see \code{\link{calc_densities}}. Needed to relate \code{npop} to \code{w}, if they are not both specified.}

\item{unit.size}{Unit size, see \code{\link{calc_densities}}. Needed to relate \code{npop} to \code{w}, if they are not both specified.}

\item{randomize}{should the order of sampled dots be randomized? The dots are sampled class-wise (specified by \code{vars}). If this order is not randomized (so if \code{randomize=FALSE}), then the dots from the last class will be drawn on top, which may introduce a perception bias. By default \code{randomize=TRUE}, so the sampled dots are randomized to prevent this bias.}

\item{...}{other arguments passed on to \code{\link{calc_densities}} and \code{\link{approx_areas}}}
}
\description{
Sample dots from spatial polygons according to a spatial distribution of a population. The population may consist of classes. The output, a SpatialPointsDataFrame, can be used to create a dot map (see \code{\link{tm_dots}}), where the dots are colored according to the classes.
}
\details{
The sampling algoritm is the following: TO DO
}
\examples{
data(World)
World_dots <- sample_dots(World, vars="pop_est_dens", nrow=200, ncol=400, w=1e6)

tm_shape(World_dots) + tm_dots(size = .02, jitter=.1) + 
    tm_layout("One dot represents one million people", title.position = c("right", "bottom"))

\dontrun{
	# download Dutch neighborhood shape file
	dir <- tempdir()
	temp <- tempfile()
	
	download.file("http://www.cbs.nl/nl-NL/menu/themas/dossiers/nederland-regionaal/links/
				  2014-buurtkaart-shape-versie-1-el.htm", temp, mode="wb")
	unzip(temp, exdir = dir)
	
	NLD_nbhd <- read_shape(file.path(dir, "buurt_2014.shp"))
	
	# fix self-intersection but in shape object
	NLD_nbhd <- rgeos::gBuffer(NLD_nbhd, byid=TRUE, width=0)
	
	# remove all water neighborhoods
	NLD_nbhd <- NLD_nbhd[NLD_nbhd$OPP_LAND>0, ]
	
	# process data
	NLD_nbhd@data <- within(NLD_nbhd@data, {
		# convert land area ("OPP_LAND") from hectare (ha) to km2
		OPP_LAND <- OPP_LAND / 100
		
		# set negative percentages of western and non-western immigrants to 0
		P_WEST_AL[P_WEST_AL<0] <- 0
		P_N_W_AL[P_N_W_AL<0] <- 0
		
		# calculate population density values
		dens <- (AANT_INW / OPP_LAND)
		dens[is.nan(dens)] <- 0
		
		# divide population in three groups: 
		# western and non-western immigrants, and native Dutch
		west <- dens * P_WEST_AL / 100
		non_west <- dens * P_N_W_AL / 100
		dutch <- dens - non_west - west
	})
	
	# Select The Hague (Den Haag) area
	DH_bbox <- bb(NLD_nbhd[which(NLD_nbhd$GM_NAAM=="'s-Gravenhage"), ])
	
	# Crop shape to The Hague area (use 1.05 bounding box extension to make sure the
	# whole region is covered after reprojection to the Mercator porjection)
	DH_nbhd <- raster::crop(NLD_nbhd, bb(DH_bbox, 1.05))
	
	# Read OSM layer
	DH_nbhd_osm <- read_osm(bb(DH_bbox, current.projection="rd", projection="longlat"), 
							type = "mapquest")
	
	# Sample dots (each dot represents 100 persons)
	DH_nbhd_dots <- sample_dots(DH_nbhd, c("dutch", "west", "non_west"), 
		convert2density = FALSE, 
		N=250000, w=100, 
		var.labels = c("Dutch (native)", "Western immigrants", "Non-western immigrants"), 
		shp.id = "ID")
	
	# Show map
	tm_shape(DH_nbhd_osm) + tm_raster(saturation=.2) +
		tm_shape(DH_nbhd_dots) + 
		    tm_dots("class", size=.04, alpha=.75, palette="Dark2", 
		    		title = "The Hague population") +
		tm_layout(inner.margins=0, legend.frame=TRUE, legend.bg.color="grey90")
}
}

