% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{addTkBind}
\alias{addTkBind}
\title{Add Tk Binds}
\usage{
addTkBind(win, event, fun)
}
\arguments{
\item{win}{window}

\item{event}{event}

\item{fun}{a function}
}
\description{
Add binds to previous defined bindings
}
\details{
This function adds a new bind while keeping the previous defined binds.
}
\examples{
\dontshow{

tt <- tktoplevel()
tt <- tkRplot(tt, function () plot(1:10))
FUN <- local({
  canPos <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
    function (x, y) {
        x <- as.numeric(x)
        y <- as.numeric(y)
       tkdelete(tt$env$canvas, tclvalue(canPos))
           xy <- formatC(tk2usr(x, y),
                   digits = 2,
                     format = "f",
                       width = 5)
    canPos <<- .Tcl(
     paste(tt$env$canvas, "create text 40 10 -fill blue -justify left -text { ",
            xy[1], " ", xy[2],
            "} -font {Helvetica -10}"))
  }})

tkbind(tt$env$canvas, "<Motion>", FUN)
tkbind(tt$env$canvas, "<Motion>") #to give current bidings
FUN1 <- function (x,y) print(tk2usr(x,y))
addTkBind(tt$env$canvas, "<Motion>", FUN1)
tkbind(tt$env$canvas, "<Motion>") #to give current bidings
Sys.sleep(1)
tkdestroy(tt)
}
\dontrun{

tt <- tktoplevel()
tt <- tkRplot(tt, function () plot(1:10))
FUN <- local({
  canPos <-.Tcl(paste(tt$env$canvas, "create text 0 0 "))
    function (x, y) {
        x <- as.numeric(x)
        y <- as.numeric(y)
       tkdelete(tt$env$canvas, tclvalue(canPos))
           xy <- formatC(tk2usr(x, y),
                   digits = 2,
                     format = "f",
                       width = 5)
    canPos <<- .Tcl(
     paste(tt$env$canvas, "create text 40 10 -fill blue -justify left -text { ",
            xy[1], " ", xy[2],
            "} -font {Helvetica -10}"))
  }})

tkbind(tt$env$canvas, "<Motion>", FUN)
tkbind(tt$env$canvas, "<Motion>") #to give current bidings
FUN1 <- function (x,y) print(tk2usr(x,y))
addTkBind(tt$env$canvas, "<Motion>", FUN1)
tkbind(tt$env$canvas, "<Motion>") #to give current bidings
}
}
