% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latex.R
\name{parse_packages}
\alias{parse_packages}
\title{Find missing LaTeX packages from a LaTeX log file}
\usage{
parse_packages(log, text = readLines(log), files = detect_files(text), quiet = FALSE)
}
\arguments{
\item{log}{Path to the LaTeX log file (typically named \file{*.log}).}

\item{text}{A character vector of the error log (read from the file provided
by the \code{log} argument by default).}

\item{files}{A character vector of names of the missing files (automatically
detected from the \code{log} by default).}

\item{quiet}{Whether to suppress messages when finding packages.}
}
\value{
A character vector of LaTeX package names.
}
\description{
Analyze the error messages in a LaTeX log file to figure out the names of
missing LaTeX packages that caused the errors. These packages can be
installed via \code{\link{tlmgr_install}()}. Searching for missing packages
is based on \code{\link{tlmgr_search}()}.
}
