% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sffsBinary}
\alias{sffsBinary}
\title{Model selection with sffs for the binary drug-target interaction data}
\usage{
sffsBinary(profile_data, sens, sp = 1, max_k = 2, loo = TRUE,
  verbosity = FALSE)
}
\arguments{
\item{profile_data}{drug-target interaction data which is a matrix with drugs as row indexes and targets
as column indexes.}

\item{sens}{a drug sensitivity vector.}

\item{sp}{an integer to specify the starting point for sequential forward floating search (sffs) search
algorithm to navigate the target set space. By default, sp = 1.}

\item{max_k}{an integer to sepcify the maximum number of targets that can be selected by the sffs
algorithm. By default, max_k = 2. In practice it should not be over than 10 as the number of target combinations will increase exponentially.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = True.}

\item{verbosity}{a boolean value to decide if the information should be displayed. If it is TRUE, the information
will be displayed while the model is running. Otherwise, the information will not be displayed. By default, it is
FALSE.}
}
\value{
A list containing the following components:
\item{timma}{a list contains: the predicted efficacy matrix, prediction error and predicted drug sensitivity}
\item{k_sel}{the indexes for selected targets}
}
\description{
A function to select the most predictive targets with sffs for the binary drug-target interaction data using
orignal maximization and minimization rules
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
results<-sffsBinary(tyner_interaction_binary, tyner_sensitivity[, 1], max_k = 2)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

