% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{fitWindow}
\alias{fitWindow}
\title{Adjust the visible window such that it fits all items}
\usage{
fitWindow(id, options)
}
\arguments{
\item{id}{Timeline id or a \code{timevis} object (the output from \code{timevis()})}

\item{options}{Named list of options controlling the animation. Most common
option is \code{"animation" = TRUE/FALSE}. For a full list of options, see
the "fit" method in the
\href{https://visjs.org/docs/timeline/#Methods}{official
Timeline documentation}}
}
\description{
Adjust the visible window such that it fits all items
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Fit all items")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis(data.frame(
        id = 1:2, start = c(Sys.Date(), Sys.Date() - 1), content = c("1", "2")
      ))
    )
    observeEvent(input$btn, {
      fitWindow("timeline", list(animation = FALSE))
    })
  }
)
}
}
