this_quarter <-
  function(x = Sys.Date(),
           part = getOption("timeperiodsR.parts")) {
    
    if ( ! "Date" %in% class(x) ) {
      x <- as.Date(x)
    }
    
    start <- floor_date( x, unit = "quarter" )
    stop  <- ceiling_date( x, unit = "quarter" ) - days(1)
    out   <- custom_period(start, stop)
  
  part <- match.arg(part, getOption("timeperiodsR.parts"))
  
  if ( part == "all" ) {
    return(out) 
  } else {
    return(out[[part]]) 
  } 
}
