% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/transportation.R
\name{primary_roads}
\alias{primary_roads}
\title{Download a national primary roads shapefile into R}
\usage{
primary_roads(...)
}
\arguments{
\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}), and \code{year}, the year for which you'd like to download data
(defaults to 2014).}
}
\description{
From the Census Bureau: "Primary roads are generally divided,
limited-access highways within the Federal interstate highway
system or under state management. These highways are distinguished by the
presence of interchanges
and are accessible by ramps and may include some toll highways."
}
\examples{
\dontrun{
library(tigris)
library(sp)

rds <- primary_roads()

plot(rds)

}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2014/TGRSHP2014_TechDoc.pdf}

Other transportation functions: \code{\link{primary_secondary_roads}};
  \code{\link{rails}}; \code{\link{roads}}
}

