% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_query.R
\name{tw_query}
\alias{tw_query}
\title{Perform simple Wikidata queries}
\usage{
tw_query(
  query,
  fields = c("item", "itemLabel", "itemDescription"),
  language = "en",
  return_as_tw_search = TRUE
)
}
\arguments{
\item{query}{A list of named vectors, or a data frame (see example and readme).}

\item{fields}{A character vector of Wikidata fields. Ignored if \code{return_as_tw_search} is set to TRUE (as per default). Defaults to \verb{("item", "itemLabel", "itemDescription")}}

\item{language}{Two letter code of preferred language, defaults to "en". If more than one, can be set in order of preference, e.g. \code{c("it", "fr", "en")}}

\item{return_as_tw_search}{Logical, defaults to TRUE. If TRUE, returns a data frame with three columns (id, label, and description) that can be piped to other \code{tw_} functions. If FALSE, a data frame with as many columns as fields.}
}
\value{
A data frame
}
\description{
This function aims to facilitate only the most basic type of queries: return which items have the following property pairs. For more details on Wikidata queries, consult: https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples. For complex queries, use \code{WikidataQueryServiceR::query_wikidata()}
}
\examples{

if (interactive()) {
  query <- list(
    c(p = "P106", q = "Q1397808"),
    c(p = "P21", q = "Q6581072")
  )
  tw_query(query)
}
}
