% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_label.R
\name{tw_label}
\alias{tw_label}
\title{Gets labels for all columns with names such as "id" and "property".}
\usage{
tw_label(
  df,
  value = TRUE,
  language = "en",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0
)
}
\arguments{
\item{df}{A data frame, typically generated with other \code{tidywikidatar} functions such as \code{tw_get_property()}}

\item{value}{Logical, defaults to TRUE. If TRUE, it tries to get labels for all supposed id in the column called value. May break if the columns include some value which starts with Q and some digits, but is not a wikidata id.}

\item{language}{Defaults to "en". For available values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}
}
\value{
A data frame, with the same shape as the input data frame, but with labels instead of identifiers.
}
\description{
Gets labels for all columns with names such as "id" and "property".
}
\examples{

tw_get_qualifiers(id = "Q180099", p = "P26", language = "en") \%>\%
  tw_label()
}
