% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_download.R
\name{tt_download}
\alias{tt_download}
\title{download tt data}
\usage{
tt_download(tt, files = c("All"), ..., branch = "master", auth = github_pat())
}
\arguments{
\item{tt}{a `tt` object, output from \code{\link{tt_load_gh}}}

\item{files}{List the file names to download. Default to asking.}

\item{...}{pass methods to the parsing functions. These will be passed to
ALL files, so be careful.}

\item{branch}{which branch to be downloading data from. Default and always
should be "master".}

\item{auth}{github Personal Access Token. See PAT section for more
information}
}
\value{
list of tibbles of the files downloaded.
}
\description{
Download all or specific files identified in the tt dataset
}
\section{PAT}{


A Github PAT is a personal Access Token. This allows for signed queries to
the github api, and increases the limit on the number of requests allowed
from 60 to 5000. Follow instructions at
<https://happygitwithr.com/github-pat.html> to set the PAT.
}

\examples{
\donttest{
if(interactive()){
tt_output <- tt_load_gh("2019-01-15")
agencies <- tt_download(tt_output, files = "agencies.csv")
}
}
}
