% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.Spat.R
\name{mutate.Spat}
\alias{mutate.Spat}
\alias{mutate.SpatRaster}
\alias{transmute.Spat}
\alias{mutate.SpatVector}
\alias{transmute.SpatRaster}
\alias{transmute.SpatVector}
\title{Create, modify, and delete cell values/layers/attributes of Spat* objects}
\usage{
\method{mutate}{SpatRaster}(.data, ...)

\method{mutate}{SpatVector}(.data, ...)

\method{transmute}{SpatRaster}(.data, ...)

\method{transmute}{SpatVector}(.data, ...)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[dplyr:mutate]{data-masking}} Name-value pairs. The name gives
the name of the layer/attribute in the output. See \code{\link[dplyr:mutate]{dplyr::mutate()}}.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\code{mutate()} adds new layers/attributes and preserves existing ones on a
Spat* object. \code{transmute()} adds new layers/attributes and drops existing
ones. New variables overwrite existing variables of the same name. Variables
can be removed by setting their value to \code{NULL}.
}
\section{terra equivalent}{


Some terra methods for modifying cell values:
\code{\link[terra:ifelse]{terra::ifel()}}, \code{\link[terra:classify]{terra::classify()}}, \code{\link[terra:clamp]{terra::clamp()}}, \code{\link[terra:app]{terra::app()}},
\code{\link[terra:lapp]{terra::lapp()}}, \code{\link[terra:tapp]{terra::tapp()}}
}

\section{Methods}{


Implementation of the \strong{generics} \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:transmute]{dplyr::transmute()}}
functions.
\subsection{SpatRaster}{

Add new layers and preserves existing ones. The result is a
SpatRaster with the same extent, resolution and crs than \code{.data}. Only the
values (and possibly the number) of layers is modified.

\code{transmute()} would keep only the layers created with \code{...}.
}

\subsection{SpatVector}{

This method relies on the implementation of \code{\link[dplyr:mutate]{dplyr::mutate()}} method on the
sf package. The result is a SpatVector with the modified (and possibly
renamed) attributes on the function call.

\code{transmute()} would keep only the attributes created with \code{...}.
}
}

\examples{

library(terra)

# SpatRaster method
f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
spatrast <- rast(f)

mod <- spatrast \%>\%
  mutate(exp_lyr1 = exp(tavg_04 / 10)) \%>\%
  select(tavg_04, exp_lyr1)

mod
plot(mod)

# SpatVector method
f <- system.file("extdata/cyl.gpkg", package = "tidyterra")
v <- vect(f)

v \%>\%
  mutate(cpro2 = paste0(cpro, "-CyL")) \%>\%
  select(cpro, cpro2)
}
\seealso{
\code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:transmute]{dplyr::transmute()}}

Other dplyr methods:
\code{\link{filter.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}},
\code{\link{slice.Spat}}

Other single table verbs: 
\code{\link{filter.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}},
\code{\link{slice.Spat}}
}
\concept{dplyr.methods}
\concept{single table verbs}
