% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_wiki.R
\name{scale_wiki}
\alias{scale_wiki}
\alias{scale_fill_wiki_d}
\alias{scale_colour_wiki_d}
\alias{scale_color_wiki_d}
\alias{scale_fill_wiki_c}
\alias{scale_colour_wiki_c}
\alias{scale_color_wiki_c}
\alias{scale_fill_wiki_b}
\alias{scale_colour_wiki_b}
\alias{scale_color_wiki_b}
\alias{wiki.colors}
\title{Gradient scales from Wikipedia color schemes}
\usage{
scale_fill_wiki_d(..., alpha = 1, direction = 1)

scale_colour_wiki_d(..., alpha = 1, direction = 1)

scale_fill_wiki_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_colour_wiki_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_fill_wiki_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)

scale_colour_wiki_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)

wiki.colors(n, alpha = 1, rev = FALSE)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}, or \code{\link[ggplot2:binned_scale]{binned_scale()}} to control name, limits, breaks,
labels and so forth.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{n}{the number of colors (\eqn{\ge 1}) to be in the
    palette.}

\item{rev}{logical indicating whether the ordering of the colors should
    be reversed.}
}
\value{
The corresponding ggplot2 layer with the values applied to the
\code{fill/colour} aesthetics.
}
\description{
Implementation based on the
\href{https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Maps/Conventions/Topographic_maps}{Wikipedia Colorimetric conventions for topographic maps}.
Three scales are provided:
\itemize{
\item \verb{scale_*_wiki_d()}: For discrete values.
\item \verb{scale_*_wiki_c()}: For continuous values.
\item \verb{scale_*_wiki_b()}: For binning continuous values.
}

Additionally, a color palette \code{wiki.colors()} is provided. See also
\code{\link[grDevices:palettes]{grDevices::terrain.colors()}} for details.
}
\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

# Palette
plot(volcano2_rast, col = wiki.colors(100))

library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_wiki_c()

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_wiki_b(breaks = seq(70, 200, 10))

# With discrete values
factor <- volcano2_rast \%>\% mutate(cats = cut(elevation,
  breaks = c(100, 120, 130, 150, 170, 200),
  labels = c(
    "Very Low", "Low", "Average", "High",
    "Very High"
  )
))


ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_wiki_d(na.value = "gray10")
}
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

Other gradient scales and palettes for hypsometry:
\code{\link{scale_cross_blended}},
\code{\link{scale_hypso}},
\code{\link{scale_terrain}},
\code{\link{scale_whitebox}}
}
\concept{gradients}
