% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-min-max.R
\name{slice_min.}
\alias{slice_min.}
\title{Choose rows in a data.table}
\usage{
slice_min.(.df, order_by, n = 1, ..., with_ties = TRUE, .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{order_by}{Variable to arrange by}

\item{n}{Number of rows to grab}

\item{...}{Integer row values}

\item{with_ties}{Should ties be kept together. The default \code{TRUE} may return
can return multiple rows if they are equal. Use \code{FALSE} to ignore ties.}

\item{.by}{Columns to group by}
}
\description{
Choose rows in a data.table.
Grouped data.tables grab rows within each group.
}
\examples{
df <- data.table(
  x = 1:4,
  y = 5:8,
  z = c("a", "a", "a", "b")
)

df \%>\%
  slice(1:3)

df \%>\%
  slice(1, 3)

df \%>\%
  slice(1:2, .by = z)

df \%>\%
  slice_head(1, .by = z)

df \%>\%
  slice_tail(1, .by = z)

df \%>\%
  slice_max(order_by = x, .by = z)

df \%>\%
  slice_min(order_by = y, .by = z)
}
\keyword{internal}
