% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_lmm.r
\name{report_lmm}
\alias{report_lmm}
\title{Report method for linear mixed models}
\usage{
report_lmm(identifier, group = NULL, term = NULL, term_nr = NULL,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{group}{A character string indicating the group containing the
statistics you want to report.}

\item{term}{A character string indicating the term you want to report.}

\item{term_nr}{A number indicating the term you want to report.}

\item{results}{A tidystats list.}
}
\description{
Function to report a linear mixed model in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the default results list
options(tidystats_list = results)

# Example: regression term
report("lme4_lme", term = "Days")
report("lmerTest_lme", term = "Days")

}
