% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqapply.R
\name{sqapply}
\alias{sqapply}
\title{Apply function to each sequence}
\usage{
sqapply(
  x,
  fun,
  ...,
  single_string = FALSE,
  NA_letter = getOption("tidysq_NA_letter")
)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{fun}{[\code{function(1)}]\cr
A function to apply to each sequence in \code{sq} object; it should
take a character vector, numeric vector or single character string as an input.}

\item{...}{further arguments to be passed from or to other methods.}

\item{single_string}{[\code{logical(1)}]\cr
A value indicating in which form sequences should be
passed to the function \code{fun}; if \code{FALSE} (default), they will be treated as character
vectors, if \code{TRUE}, they will be pasted into a single string.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
A list of values returned by function for each sequence in corresponding order.
}
\description{
Applies given function to each sequence. Sequences are passed to function as character vectors
(or numeric, if type of \code{sq} is \strong{enc}) or single character strings, depending on 
parameter.
}
\examples{
# Creating objects to work on:
sq_dna <- sq(c("ATGCAGGA", "GACCGNBAACGAN", "TGACGAGCTTA"),
             alphabet = "dna_bsc")
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_unt <- sq(c("ATGCAGGA?", "TGACGAGCTTA", "", "TIAALGNIIYRAIE"))

# Counting how may "A" elements are present in sequences:

sqapply(sq_dna, function(sequence) sum(sequence == "A"))
sqapply(sq_ami, function(sequence) sum(sequence == "A"))
sqapply(sq_unt, function(sequence) sum(sequence == "A"))

}
\seealso{
\code{\link[=sq-class]{sq}} \code{\link[base]{lapply}}
}
