% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{filter}
\alias{filter}
\title{Subset rows using column values}
\usage{
filter(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{<[`tidy-eval`][dplyr_tidy_eval]> Logical predicates defined in
terms of the variables in `.data`.
Multiple conditions are combined with `&`. Only rows where the
condition evaluates to `TRUE` are kept.}

\item{.preserve}{when `FALSE` (the default), the grouping structure
is recalculated based on the resulting data, otherwise it is kept as is.}
}
\value{
An object of the same type as `.data`.

* Rows are a subset of the input, but appear in the same order.
* Columns are not modified.
* The number of groups may be reduced (if `.preserve` is not `TRUE`).
* Data frame attributes are preserved.
}
\description{
`filter()` retains the rows where the conditions you provide a `TRUE`. Note
that, unlike base subsetting with `[`, rows where the condition evaluates
to `NA` are dropped.
}
\details{
dplyr is not yet smart enough to optimise filtering optimisation
on grouped datasets that don't need grouped calculations. For this reason,
filtering is often considerably faster on [ungroup()]ed data.
}
\section{Useful filter functions}{


* [`==`], [`>`], [`>=`] etc
* [`&`], [`|`], [`!`], [xor()]
* [is.na()]
* [between()], [near()]
}

\section{Grouped tibbles}{


Because filtering expressions are computed within groups, they may
yield different results on grouped tibbles. This will be the case
as soon as an aggregating, lagging, or ranking function is
involved. Compare this ungrouped filtering:


The former keeps rows with `mass` greater than the global average
whereas the latter keeps rows with `mass` greater than the gender

average.
}

\section{Methods}{

This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
}

\examples{

`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% filter(groups == "g1")

# Learn more in ?dplyr_tidy_eval
}
\seealso{
[filter_all()], [filter_if()] and [filter_at()].

Other single table verbs: 
\code{\link{arrange}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
