% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c5.R
\name{tidyRules.C5.0}
\alias{tidyRules.C5.0}
\title{Obtain rules as a tidy tibble from a C5.0 model}
\usage{
\method{tidyRules}{C5.0}(object, ...)
}
\arguments{
\item{object}{Fitted model object with rules}

\item{...}{Other arguments (See details)}
}
\value{
A tibble where each row corresponds to a rule. The columns are:
  support, confidence, lift, lhs, rhs, n_conditions
}
\description{
Each row corresponds to a rule. A rule can be copied into
  `dplyr::filter` to filter the observations corresponding to a rule
}
\details{
Optional named argument laplace(flag, default: TRUE) is supported.
  This computes confidence with laplace correction as documented under
  'Rulesets' here: [C5 doc](https://www.rulequest.com/see5-unix.html)
}
\examples{
data("attrition", package = "rsample")
attrition <- tibble::as_tibble(attrition)
c5_model <- C50::C5.0(Attrition ~., data = attrition, rules = TRUE)
summary(c5_model)
tidyRules(c5_model)
}
\author{
Srikanth KS, \email{sri.teach@gmail.com}
}
