% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_xts.R
\name{as_xts}
\alias{as_xts}
\alias{as_xts_}
\title{Coerce objects to xts, designed to work with tibble and data.frame objects}
\usage{
as_xts(x, date_col = NULL, ...)

as_xts_(x, date_col = NULL, ...)
}
\arguments{
\item{x}{A data.frame (with date column), matrix, xts, zoo, timeSeries, etc object.}

\item{date_col}{Required for objects that inherit the \code{data.frame} class.
Must specify a date column that is of the \code{date} class. Unused for
non-data.frame objects.}

\item{...}{Additional parameters passed to \code{xts::as.xts}.}
}
\value{
Returns a \code{xts} object.
}
\description{
Coerce objects to xts, designed to work with tibble and data.frame objects
}
\details{
\code{as_xts} is a wrapper for \code{xts::as.xts}
that includes a \code{date_col} argument. When \code{date_col} is specified,
the date column is used as row names during coercion to \code{xts} class. The
date column must be in a date format (i.e. \code{date} class).

\code{as_xts_} evaluates the \code{date_col} using Non-Standard Evaluation
(NSE). See \code{vignette("nse")} for details.

It is possible to coerce non-data.frame-like objects including
\code{zoo}, \code{timeSeries}, \code{ts}, and \code{irts} objects.
There is no need to specify the \code{date_col} argument.
}
\examples{
# Load libraries
library(tidyverse)
library(tidyquant)

tq_get("AAPL", get = "stock.prices") \%>\%
    as_xts(date_col = date)

# Non-Standard Evaluation (NSE)
x <- "date"
tq_get("AAPL", get = "stock.prices") \%>\%
    as_xts_(date_col = x)

}
\seealso{
\code{\link[=as_tibble]{as_tibble()}}
}
