% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_ollama.R
\name{ollama}
\alias{ollama}
\title{Ollama API Provider Function}
\usage{
ollama(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the appropriate Ollama-specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument specifying the verb (e.g., \code{chat}, \code{embed})
the function is invoked from. This argument is automatically managed by \code{tidyllm} and
should not be set by the user.}
}
\value{
The result of the requested action:
\itemize{
\item For \code{chat()}: An updated \code{LLMMessage} object containing the model's response.
\item For \code{embed()}: A matrix where each column corresponds to an embedding.
}
}
\description{
The \code{ollama()} function acts as an interface for interacting with local AI models via the Ollama API.
It integrates seamlessly with the main \code{tidyllm} verbs such as \code{chat()} and \code{embed()}.
}
\details{
Some functionalities, like \code{ollama_download_model()} or \code{ollama_list_models()}
are unique to the Ollama API and do not have a general verb counterpart.
These functions can be only accessed directly.

Supported Verbs:
\itemize{
\item \strong{\code{chat()}}: Sends a message to an Ollama model and retrieves the model's response.
\item \strong{\code{embed()}}: Generates embeddings for input texts using an Ollama model.
\item \strong{\code{send_batch()}}: Behaves different than the other \code{send_batch()} verbs since it immediately processes the answers
}
}
