% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_functions.R
\name{chatgpt}
\alias{chatgpt}
\title{Call the OpenAI API to interact with ChatGPT or o-reasoning models}
\usage{
chatgpt(
  .llm,
  .model = "gpt-4",
  .max_tokens = 1024,
  .temperature = NULL,
  .top_p = NULL,
  .top_k = NULL,
  .frequency_penalty = NULL,
  .presence_penalty = NULL,
  .api_url = "https://api.openai.com/",
  .timeout = 60,
  .verbose = FALSE,
  .wait = TRUE,
  .min_tokens_reset = 0L,
  .stream = FALSE
)
}
\arguments{
\item{.llm}{An existing LLMMessage object or an initial text prompt.}

\item{.model}{The model identifier (default: "gpt-4o").}

\item{.max_tokens}{The maximum number of tokens to generate (default: 1024).}

\item{.temperature}{Control for randomness in response generation (optional).}

\item{.top_p}{Nucleus sampling parameter (optional).}

\item{.top_k}{Top k sampling parameter (optional).}

\item{.frequency_penalty}{Controls repetition frequency (optional).}

\item{.presence_penalty}{Controls how much to penalize repeating content (optional)}

\item{.api_url}{Base URL for the API (default: https://api.openai.com/v1/completions).}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.verbose}{Should additional information be shown after the API call}

\item{.wait}{Should we wait for rate limits if necessary?}

\item{.min_tokens_reset}{How many tokens should be remaining to wait until we wait for token reset?}

\item{.stream}{Stream back the response piece by piece (default: FALSE).}
}
\value{
Returns an updated LLMMessage object.
}
\description{
Call the OpenAI API to interact with ChatGPT or o-reasoning models
}
