% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fit_lda_c}
\alias{fit_lda_c}
\title{Main C++ Gibbs sampler for Latent Dirichlet Allocation}
\usage{
fit_lda_c(
  Docs,
  Zd_in,
  Cd_in,
  Cv_in,
  Ck_in,
  alpha_in,
  eta_in,
  iterations,
  burnin,
  optimize_alpha,
  calc_likelihood,
  Beta_in,
  freeze_topics,
  threads = 1L,
  verbose = TRUE
)
}
\arguments{
\item{Docs}{List with one element for each document and one entry for each token
as formatted by \code{\link[tidylda]{initialize_topic_counts}}}

\item{Zd_in}{List with one element for each document and one entry for each token
as formatted by \code{\link[tidylda]{initialize_topic_counts}}}

\item{Cd_in}{IntegerMatrix denoting counts of topics in documents}

\item{Cv_in}{IntegerMatrix denoting counts of tokens in topics}

\item{Ck_in}{IntegerVector denoting counts of topics across all tokens}

\item{alpha_in}{NumericVector prior for topics over documents}

\item{eta_in}{NumericMatrix for prior of tokens over topics}

\item{iterations}{int number of gibbs iterations to run in total}

\item{burnin}{int number of burn in iterations}

\item{optimize_alpha}{bool do you want to optimize alpha each iteration?}

\item{calc_likelihood}{bool do you want to calculate the log likelihood each
iteration?}

\item{Beta_in}{NumericMatrix denoting probability of tokens in topics}

\item{freeze_topics}{bool if making predictions, set to \code{TRUE}}

\item{threads}{unsigned integer, how many parallel threads?
For now, nothing is actually parallel}

\item{verbose}{bool do you want to print out a progress bar?}
}
\value{
Returns a list with the following entries.

  \code{Cd} is a matrix counting the number of times each topic is sampled per
  document.
  
  \code{Cv} is a matrix counting the number of times each topic is sampled per token.
  
  \code{Cd_mean} the same as \code{Cd} but values averaged across iterations
  greater than \code{burnin} iterations.
  
  \code{Cv_mean} the same as \code{Cv} but values averaged across iterations
  greater than \code{burnin} iterations.
  
  \code{Cd_sum} the same as \code{Cd} but values summed across iterations
  greater than \code{burnin} iterations.
  
  \code{Cv_sum} the same as \code{Cv} but values summed across iterations
  greater than \code{burnin} iterations.
  
  \code{log_likelihood} a matrix with one row indexing iterations and one
  row of the log likelihood for each iteration.
  
  \code{alpha} a vector of the document-topic prior
  
  \code{_eta} a matrix of the topic-token prior
}
\description{
This is the C++ Gibbs sampler for LDA. "Abandon all hope, ye who enter here."
}
\details{
Arguments ending in \code{_in} are copied and their copies modified in
  some way by this function. In the case of \code{eta_in} and \code{Beta_in},
  the only modification is that they are converted from matrices to nested
  \code{std::vector} for speed, reliability, and thread safety. In the case
  of all others, they may be explicitly modified during training.
}
\keyword{internal}
