% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-transformation.R
\name{variable_trans}
\alias{variable_trans}
\alias{trans_log10}
\alias{trans_quadratic}
\alias{trans_square_root}
\alias{trans_cubic_root}
\title{The variable transformation module}
\usage{
variable_trans(data, ...)

trans_log10(var)

trans_quadratic(var)

trans_square_root(var)

trans_cubic_root(var)
}
\arguments{
\item{data}{an index table object}

\item{...}{an variable transformation recipe of class \code{var_trans},
created by \code{trans_*} function, the transformation recipe to be
evaluated}

\item{var}{used in \code{trans_*} functions, the variable to be transformed}
}
\value{
an index table object
}
\description{
The variable transformation module is used to transform a single variable
in the index table object. The transformation is specified by a variable
transformation object of class \code{var_trans}, created by
 \code{trans_*} functions. Currently, the following transformation functions
 are supported: \code{trans_log10}, \code{trans_quadratic},
 \code{trans_square_root}, and \code{trans_cubic_root}.
}
\examples{
hdi |> init() |> variable_trans(gni_pc = trans_log10(gni_pc))
}
