% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swap-values.R
\name{swap_values}
\alias{swap_values}
\alias{swap_exprs}
\title{Testing alternatives}
\usage{
swap_values(data, .var, .param, .values)

swap_exprs(data, .var, .exprs)
}
\arguments{
\item{data}{an \code{idx_tbl} object}

\item{.var}{the name of the variable, which the step is tested for
alternatives}

\item{.param}{the name of the parameter to swap}

\item{.values, .exprs}{a list of values or expressions}
}
\value{
an index table
}
\description{
The two functions allows you to substitute a value/expression in the pipeline
with other options. These functions will evaluate the modified pipeline step,
as well as its prior and subsequent steps to create different versions of the
index.
}
\examples{
library(generics)
hdi_paras <- hdi_scales |>
dplyr::add_row(dimension = "Education", name = "Education",
               var = "sch", min = 0, max = 0) |>
  dplyr::mutate(weight = c(1/3, 0, 0, 1/3, 1/3),
                weight2 = c(0.1, 0, 0, 0.8, 0.1),
                weight3 = c(0.8, 0, 0, 0.1, 0.1),
                weight4 = c(0.1, 0, 0, 0.1, 0.8))

dt <- hdi |>
  init(id = country) |>
  add_paras(hdi_paras, by = var) |>
  rescaling(life_exp = rescale_minmax(life_exp, min = min, max = max)) |>
  rescaling(exp_sch = rescale_minmax(exp_sch, min = min, max = max)) |>
  rescaling(avg_sch = rescale_minmax(avg_sch, min = min, max = max)) |>
  rescaling(gni_pc = rescale_minmax(gni_pc, min = min, max = max)) |>
  dimension_reduction(sch = aggregate_manual(~(exp_sch + avg_sch)/2)) |>
  dimension_reduction(index = aggregate_linear(~c(life_exp, sch, gni_pc),
                      weight = weight))


dt2 <- dt |>
  swap_values(.var = "index", .param = weight,
              .value = list(weight2, weight3, weight4))
augment(dt2)

dt3 <- dt |>
  swap_exprs(.var = index, .exprs = list(
             aggregate_geometrical(~c(life_exp, sch, gni_pc))))
augment(dt3)
}
