% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geocode addresses in a dataframe}
\usage{
geocode(
  .tbl,
  address = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  postalcode = NULL,
  country = NULL,
  lat = lat,
  long = long,
  return_addresses = FALSE,
  unique_only = FALSE,
  ...
)
}
\arguments{
\item{.tbl}{dataframe containing addresses}

\item{address}{single line street address column name. Do not combine with 
address component arguments (street, city, county, state, postalcode, country)}

\item{street}{street address column name}

\item{city}{city column name}

\item{county}{county column name}

\item{state}{state column name}

\item{postalcode}{postalcode column name (zip code if in the United States)}

\item{country}{country column name}

\item{lat}{latitude column name. Can be quoted or unquoted (ie. lat or 'lat').}

\item{long}{longitude column name. Can be quoted or unquoted (ie. long or 'long').}

\item{return_addresses}{if TRUE then addresses with standard names will be returned
This is defaulted to FALSE because the address fields are already in the input dataset}

\item{unique_only}{if TRUE then only unique addresses and results will be returned. 
The input dataframe's format is not preserved. Addresses will also be returned if 
TRUE (overrides return_addresses argument).}

\item{...}{arguments passed to the \code{\link{geo}} function}
}
\value{
input dataframe (.tbl) with geocoder results appended as columns
}
\description{
Takes a dataframe containing addresses as an input and returns 
the dataframe results from a specified geocoder service by using the
\code{\link{geo}} function. See example usage in \code{vignette("tidygeocoder")}.

This function passes all additional parameters (\code{...}) to the 
\code{\link{geo}} function, so you can refer to its documentation for more details
on possible arguments.

Note that the arguments used for specifying address columns (address, 
street, city, county, state, postalcode, and country) accept either
quoted or unquoted column names (ie. "address_col" and address_col are 
both acceptable).
}
\examples{
\donttest{
library(dplyr)
sample_addresses[1:2,] \%>\% geocode(addr)

louisville[1:2,] \%>\% geocode(street = street, city = city, state = state,
  postalcode = zip)

sample_addresses[8:9,] \%>\% geocode(addr, method = 'osm',
  lat = 'lattes', long = 'longos')

sample_addresses[4:5,] \%>\% geocode(addr, method = 'cascade',
  lat = latitude, long = longitude)
}
}
\seealso{
\code{\link{geo}} \code{\link{api_parameter_reference}}
}
