% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{dt_nest}
\alias{dt_nest}
\title{Fast Nesting}
\usage{
dt_nest(dt_, ..., .key = "data")
}
\arguments{
\item{dt_}{the data table to nest}

\item{...}{the variables to group by}

\item{.key}{the name of the list column; default is "data"}
}
\value{
A data.table with a list column containing data.tables
}
\description{
Quickly nest data tables (similar to \code{dplyr::group_nest()}).
}
\examples{

library(data.table)
dt <- data.table(
  x = rnorm(1e5),
  y = runif(1e5),
  grp = sample(1L:3L, 1e5, replace = TRUE)
  )

dt_nest(dt, grp)

}
