% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_methods.R
\name{base_methods_crr}
\alias{base_methods_crr}
\alias{coef.tidycrr}
\alias{model.matrix.tidycrr}
\alias{model.frame.tidycrr}
\alias{terms.tidycrr}
\title{Functions for tidycrr objects}
\usage{
\method{coef}{tidycrr}(object, ...)

\method{model.matrix}{tidycrr}(object, ...)

\method{model.frame}{tidycrr}(formula, ...)

\method{terms}{tidycrr}(x, ...)
}
\arguments{
\item{...}{not used}

\item{formula}{a formula}

\item{x, object}{a tidycrr object}
}
\value{
coef vector, model matrix, model frame, terms object
}
\description{
Functions for tidycrr objects
}
\examples{
mod <- crr(Surv(ttdeath, death_cr) ~ age + grade, trial)

coef(mod)

model.matrix(mod) \%>\% head()

model.frame(mod) \%>\% head()

terms(mod)
}
