% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cut_inclusive}
\alias{cut_inclusive}
\alias{split_by_tau}
\title{Use a changepoint set to break a time series into regions}
\usage{
cut_inclusive(x, tau)

split_by_tau(x, tau)
}
\arguments{
\item{x}{A numeric vector}

\item{tau}{a numeric vector of changepoint indices}
}
\value{
\itemize{
\item \code{\link[=cut_inclusive]{cut_inclusive()}} a \code{\link[base:factor]{base::factor()}} of half-open intervals
}

\itemize{
\item \code{\link[=split_by_tau]{split_by_tau()}} a named \code{\link[base:list]{base::list()}} of numeric
vectors
}
}
\description{
Use a changepoint set to break a time series into regions
}
\details{
A changepoint set \code{tau} of length \eqn{k} breaks a time series of length
\eqn{n} into \eqn{k+1} non-empty regions.
These non-empty regions can be defined by half-open intervals, starting with
1 and ending with \eqn{n+1}.

\code{\link[=cut_inclusive]{cut_inclusive()}} splits a set of indices into a \code{\link[base:factor]{base::factor()}} of
half-open intervals

\code{\link[=split_by_tau]{split_by_tau()}} splits a time series into a named \code{\link[base:list]{base::list()}} of numeric
vectors
}
\examples{
n <- length(CET)

# Return a factor of intervals
cut_inclusive(1:n, tau = pad_tau(c(42, 81, 330), n))

# Return a list of observations
split_by_tau(DataCPSim, c(365, 826))

}
