% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_format_translators.R
\name{tidy-format-translators}
\alias{tidy-format-translators}
\alias{to_broom_names}
\alias{from_broom_names}
\alias{to_ggmcmc_names}
\alias{from_ggmcmc_names}
\title{Translate between different tidy data frame formats for draws from distributions}
\usage{
to_broom_names(data)

from_broom_names(data)

to_ggmcmc_names(data)

from_ggmcmc_names(data)
}
\arguments{
\item{data}{A data frame to translate.}
}
\value{
A data frame with (possibly) new names in some columns, according to the
translation scheme above.
}
\description{
These functions translate tidybayes-style tidy data frames of draws to/from different tidy data frame
formats (each format using a different naming scheme).
}
\details{
Function prefixed with \code{to_} translate from the tidybayes format to another format, functions
prefixed with \code{from_} translate from that format back to the tidybayes format. Formats include:

\code{to_broom_names()} / \code{from_broom_names()}:

\itemize{
\item \code{.variable} <-> \code{term}
\item \code{.value} <-> \code{estimate}
\item \code{.prediction} <-> \code{.fitted}
\item \code{.lower} <-> \code{conf.low}
\item \code{.upper} <-> \code{conf.high}
}

\code{to_ggmcmc_names()} / \code{from_ggmcmc_names()}:

\itemize{
\item \code{.chain} <-> \code{Chain}
\item \code{.iteration} <-> \code{Iteration}
\item \code{.variable} <-> \code{Parameter}
\item \code{.value} <-> \code{value}
}
}
\examples{

library(magrittr)

data(line, package = "coda")

line \%>\%
  gather_draws(alpha, beta, sigma) \%>\%
  median_qi() \%>\%
  to_broom_names()

}
\author{
Matthew Kay
}
\keyword{manip}
