% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_corr_test.R
\name{bf_corr_test}
\alias{bf_corr_test}
\title{Bayes Factor for correlation test}
\usage{
bf_corr_test(data, x, y, bf.prior = 0.707, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or a table will \strong{not} be accepted.}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis. Can be entered either as a character string (e.g.,
\code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{...}{
  Arguments passed on to \code{\link[=bf_extractor]{bf_extractor}}
  \describe{
    \item{\code{conf.level}}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}
    \item{\code{centrality}}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}
    \item{\code{conf.method}}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default), \code{"eti"}, or \code{"si"} (see \code{si()}, \code{hdi()}, \code{eti()}
functions from \code{bayestestR} package).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{top.text}}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}
    \item{\code{output}}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}
  }}
}
\description{
Bayes Factor for correlation test
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(tidyBF)

# to get dataframe
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 0.3,
  output = "dataframe"
)

# to get expression
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 0.8,
  output = "expression"
)
}
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_ttest}}
}
